# Setup Guide

Step-by-step instructions to get reengage.email running.

**Time required:** ~15 minutes

---

## Prerequisites

- **Node.js 18+** installed ([download](https://nodejs.org))
- **An email provider** (SendGrid, Amazon SES, Mailgun, etc.)
- **Your user data** in CSV format

---

## Step 1: Install Dependencies

```bash
cd reengage-automation
npm install
```

This installs:
- `nodemailer` — for sending emails
- `node-cron` — for scheduling
- `dotenv` — for environment variables

---

## Step 2: Create Configuration Files

### 2.1 Create config.json

```bash
cp config.example.json config.json
```

Edit `config.json` with your details:

```json
{
  "business": {
    "name": "Acme Inc",                    // Your business name
    "website": "https://acme.com",         // Your website
    "supportEmail": "support@acme.com"     // Support email
  },

  "trigger": {
    "type": "no_activity",
    "daysInactive": 7                      // Days before user is "inactive"
  },

  "emails": {
    "fromName": "Acme Inc",                // Sender name
    "fromEmail": "hello@acme.com",         // Sender email (must be verified)
    "replyTo": "support@acme.com"          // Reply-to address
  }
}
```

### 2.2 Create .env file

```bash
cp .env.example .env
```

Add your SMTP credentials (see Step 3).

---

## Step 3: Set Up Email Provider

Choose one provider and follow the instructions.

### Option A: SendGrid (Recommended for beginners)

1. Create account at [sendgrid.com](https://sendgrid.com)
2. Go to **Settings → API Keys → Create API Key**
3. Choose "Full Access" and copy the key
4. Verify your sender email in **Settings → Sender Authentication**

Add to `.env`:
```
SMTP_HOST=smtp.sendgrid.net
SMTP_PORT=587
SMTP_SECURE=false
SMTP_USER=apikey
SMTP_PASS=SG.xxxxxxxxxxxxxxxxxxxx
```

### Option B: Amazon SES (Cheapest at scale)

1. Go to AWS Console → SES
2. Verify your domain or email address
3. Create SMTP credentials in **SMTP Settings**

Add to `.env`:
```
SMTP_HOST=email-smtp.us-east-1.amazonaws.com
SMTP_PORT=587
SMTP_SECURE=false
SMTP_USER=your-ses-smtp-username
SMTP_PASS=your-ses-smtp-password
```

### Option C: Mailgun

1. Create account at [mailgun.com](https://mailgun.com)
2. Add and verify your domain
3. Go to **Domain Settings → SMTP Credentials**

Add to `.env`:
```
SMTP_HOST=smtp.mailgun.org
SMTP_PORT=587
SMTP_SECURE=false
SMTP_USER=postmaster@yourdomain.com
SMTP_PASS=your-mailgun-password
```

### Option D: Gmail (For testing only)

1. Enable 2-factor authentication
2. Create an App Password at [myaccount.google.com/apppasswords](https://myaccount.google.com/apppasswords)

Add to `.env`:
```
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_SECURE=false
SMTP_USER=youremail@gmail.com
SMTP_PASS=your-app-password
```

⚠️ Gmail has sending limits. Use a real email provider for production.

---

## Step 4: Add Your Users

Create your user CSV file:

```bash
cp data/users.example.csv data/users.csv
```

Edit `data/users.csv`:

```csv
email,firstName,lastName,lastActivityDate
john@example.com,John,Doe,2024-12-15
jane@example.com,Jane,Smith,2024-12-20
mike@example.com,Mike,Wilson,2025-01-10
```

**Required columns:**
- `email` — User's email address
- `firstName` — For personalization
- `lastActivityDate` — Date of last activity (YYYY-MM-DD)

**Optional columns:**
- `lastName` — User's last name

### How to export from your app

**From a database:**
```sql
SELECT email, first_name, last_name, last_login_at
FROM users
WHERE subscribed = true;
```

**From Shopify:**
Export customers from Admin → Customers → Export

**From Stripe:**
Use the Stripe Dashboard or API to export customer data

---

## Step 5: Customize Email Templates

Edit the templates in `email_templates/`:

- `email-1-reminder.html` — First gentle nudge
- `email-2-value.html` — Remind them of value
- `email-3-urgency.html` — Final message

### Available Variables

Use these in your templates:

| Variable | Description |
|----------|-------------|
| `{{firstName}}` | User's first name |
| `{{lastName}}` | User's last name |
| `{{email}}` | User's email |
| `{{businessName}}` | Your business name |
| `{{websiteUrl}}` | Your website URL |
| `{{unsubscribeUrl}}` | Unsubscribe link |

### Example

```html
<h1>Hey {{firstName}}, we miss you!</h1>
<p>It's been a while since you visited {{businessName}}.</p>
<a href="{{websiteUrl}}">Come back and see what's new</a>
```

---

## Step 6: Test the Automation

Run a dry run (no emails sent):

```bash
npm test
```

You should see:
```
[DRY RUN] Would send email #1 to john@example.com
  Subject: We miss you, John!
```

If you see errors, check:
1. Is `config.json` valid JSON?
2. Does `data/users.csv` exist?
3. Are the dates in the correct format?

---

## Step 7: Send Real Emails

When ready, run:

```bash
npm start
```

This will:
1. Check all users for inactivity
2. Send emails to inactive users
3. Keep running and check on schedule (default: 9 AM daily)

To run once and exit:
```bash
node automation.js --once
```

---

## Step 8: Set Up for Production

### Option A: Keep it running with PM2

```bash
# Install PM2
npm install -g pm2

# Start the automation
pm2 start automation.js --name reengage

# Save the process list
pm2 save

# Set up auto-restart on reboot
pm2 startup
```

### Option B: Run daily with cron

```bash
# Open crontab
crontab -e

# Add this line (runs at 9 AM daily)
0 9 * * * cd /path/to/reengage-automation && /usr/bin/node automation.js --once >> /var/log/reengage.log 2>&1
```

---

## Troubleshooting

### "Authentication failed"
- Check your SMTP credentials in `.env`
- Make sure your sender email is verified with your provider

### "No users found"
- Check that `data/users.csv` exists
- Make sure it has the correct columns

### "Connection refused"
- Check SMTP_HOST and SMTP_PORT
- Some networks block port 587, try 465 with SMTP_SECURE=true

### Emails going to spam
- Set up SPF, DKIM, and DMARC for your domain
- Use a reputable email provider
- Don't use free email addresses as sender

---

## Updating Your User List

The automation reads the CSV fresh on each run. To update:

1. Export new data from your app
2. Replace `data/users.csv`
3. The next run will pick up the changes

Users who already received all 3 emails won't receive them again (tracked in `data/state.json`).

---

## Need Help?

- Check the [README.md](./README.md) for more details
- Review the example files
- Open an issue on GitHub

---

You're all set! The automation will now re-engage your inactive users automatically.
