# reengage.email

A simple, self-hosted email re-engagement automation for small businesses.

Automatically send a 3-email sequence to bring back inactive users. No complex dashboards. No monthly fees. Just results.

## What It Does

When a user becomes inactive (no activity for X days), the automation sends:

1. **Email 1: Friendly Reminder** — A gentle nudge saying "we miss you"
2. **Email 2: Value Reminder** — Highlights what they're missing
3. **Email 3: Last Call** — Creates urgency, offers help

Each email is spaced out (configurable) to avoid being annoying.

## Quick Start

```bash
# 1. Clone or download this folder
cd reengage-automation

# 2. Install dependencies
npm install

# 3. Set up your configuration
cp config.example.json config.json
cp .env.example .env

# 4. Edit config.json with your business details

# 5. Add your SMTP credentials to .env

# 6. Add your users to data/users.csv

# 7. Test it (no emails sent)
npm test

# 8. Run it
npm start
```

## How It Works

```
┌─────────────────┐     ┌──────────────┐     ┌─────────────┐
│  Users CSV      │────▶│  Automation  │────▶│  SMTP/Email │
│  (your users)   │     │  (checks     │     │  (SendGrid, │
│                 │     │   daily)     │     │   SES, etc) │
└─────────────────┘     └──────────────┘     └─────────────┘
                              │
                              ▼
                        ┌──────────────┐
                        │  State JSON  │
                        │  (tracks     │
                        │   sent)      │
                        └──────────────┘
```

1. You provide a CSV of users with their last activity date
2. The automation checks daily (or on your schedule)
3. Inactive users receive the email sequence
4. State is tracked to prevent duplicate emails

## Configuration

### config.json

```json
{
  "business": {
    "name": "Your Business",
    "website": "https://yourbusiness.com"
  },
  "trigger": {
    "type": "no_activity",
    "daysInactive": 7
  },
  "schedule": {
    "cron": "0 9 * * *"  // 9 AM daily
  }
}
```

### Users CSV Format

```csv
email,firstName,lastName,lastActivityDate
john@example.com,John,Doe,2024-01-15
jane@example.com,Jane,Smith,2024-01-20
```

## Email Providers

Works with any SMTP provider:

- **SendGrid** (recommended for beginners)
- **Amazon SES** (cheapest at scale)
- **Mailgun**
- **Postmark**
- **Your own SMTP server**

## Commands

```bash
# Run with scheduler (keeps running)
npm start

# Run once and exit
node automation.js --once

# Dry run (test without sending)
npm test
# or
node automation.js --dry-run
```

## Project Structure

```
reengage-automation/
├── automation.js          # Main automation logic
├── config.json            # Your configuration
├── config.example.json    # Example configuration
├── .env                   # SMTP credentials (don't commit)
├── .env.example           # Example env file
├── package.json
├── data/
│   ├── users.csv          # Your user list
│   └── state.json         # Tracks sent emails (auto-created)
└── email_templates/
    ├── email-1-reminder.html
    ├── email-2-value.html
    └── email-3-urgency.html
```

## Customizing Emails

Edit the HTML files in `email_templates/`. Available variables:

- `{{firstName}}` — User's first name
- `{{lastName}}` — User's last name
- `{{email}}` — User's email
- `{{businessName}}` — Your business name
- `{{websiteUrl}}` — Your website URL
- `{{unsubscribeUrl}}` — Unsubscribe link

## Running in Production

### Option 1: Server with PM2

```bash
npm install -g pm2
pm2 start automation.js --name reengage
pm2 save
pm2 startup
```

### Option 2: Cron Job (run daily)

```bash
# Edit crontab
crontab -e

# Add this line (runs at 9 AM daily)
0 9 * * * cd /path/to/reengage-automation && node automation.js --once
```

### Option 3: Docker

```dockerfile
FROM node:20-alpine
WORKDIR /app
COPY package*.json ./
RUN npm install --production
COPY . .
CMD ["node", "automation.js"]
```

## FAQ

**How do I update my user list?**
Just update the CSV file. The automation reads it fresh on each run.

**What if a user becomes active again?**
Update their `lastActivityDate` in the CSV. They won't receive more emails until they go inactive again.

**How do I stop emails for a specific user?**
Remove them from the CSV, or update their `lastActivityDate` to today.

**Can I customize the email timing?**
Yes, edit `delayDays` for each email in `config.json`.

## License

MIT — Use it however you want.

---

Built for businesses that want to bring back users without the complexity.
